unit reviews;

interface

uses productsDB, StrUtils, System.Web.UI, System.Drawing, System.Web.UI.WebControls;

type ReviewsDataList = Class(System.Web.UI.WebControls.DataList)
	private
		fProductID : integer; 
		procedure SetProductID(Value:integer);
	public	
    constructor Create;
  strict protected
    procedure OnLoad(E : EventArgs); override;
	published
		property ProductID : integer read fProductID write SetProductID;
end;

implementation

procedure ReviewsDataList.SetProductID(Value:integer);
begin
	if Value <> fProductID then fProductID:=Value;
end;

type
  TItemTemplate = Class(System.Object,ITemplate)
     procedure InstantiateIn(container:System.Web.UI.Control);
     procedure DoDataBinding(Sender: System.Object; E: System.EventArgs);
end;

procedure TItemTemplate.DoDataBinding(Sender: System.Object; E:System.EventArgs);
var
    aHL:System.Web.UI.WebControls.Panel;
    container: System.Web.UI.WebControls.DataListItem;
		sRating : string;
begin
    aHL:=(Sender as System.Web.UI.WebControls.Panel);
    container := (aHL.NamingContainer as System.Web.UI.WebControls.DataListItem);
		
		sRating := DataBinder.Eval((Container as DataListItem).DataItem, 'Rating').ToString;
		
		(aHL.Controls[0] as HyperLink).Text:='<b>' + DataBinder.Eval((Container as DataListItem).DataItem, 'UserName').ToString + '</b>';
		(aHL.Controls[0] as HyperLink).NavigateURL:='mailto:' + DataBinder.Eval((Container as DataListItem).DataItem, 'UserEMail').ToString;

		(aHL.Controls[2] as Image).ImageURL:='gfx/rate' + sRating + '.gif';
		
		(aHL.Controls[3] as System.Web.UI.WebControls.Label).Text:='&nbsp;['+ sRating + ']';
		
		(aHL.Controls[4] as System.Web.UI.WebControls.Label).Text:='<br>' + DataBinder.Eval((Container as DataListItem).DataItem, 'Comments').ToString + '<br>&nbsp;';
end;


procedure TItemTemplate.InstantiateIn(container:System.Web.UI.Control);
var
  aHL : System.Web.UI.WebControls.Panel;
  lnkUserName:System.Web.UI.WebControls.HyperLink;
  imgRating:System.Web.UI.WebControls.Image;
  lblComment:System.Web.UI.WebControls.Label;
begin
	aHL := System.Web.UI.WebControls.Panel.Create;
	aHL.CssClass:='Reviews';
	aHL.add_DataBinding(DoDataBinding);

  lnkUserName:=System.Web.UI.WebControls.HyperLink.create;
  imgRating:=System.Web.UI.WebControls.Image.create;
	imgRating.ImageAlign:=ImageAlign.AbsMiddle;
  lblComment:=System.Web.UI.WebControls.Label.create;
	
	aHL.Controls.Add(lnkUserName);
	aHL.Controls.Add(LiteralControl.Create('&nbsp;'));
	aHL.Controls.Add(imgRating);
	aHL.Controls.Add(System.Web.UI.WebControls.Label.create);
	aHL.Controls.Add(lblComment);

	container.Controls.Add(aHL);
end;

constructor ReviewsDataList.Create;
begin
    inherited create;
    ItemTemplate := TItemTemplate.create;
end;

procedure ReviewsDataList.OnLoad(E : EventArgs);
var
  prds : TproductsDB;
begin
	inherited OnLoad(E);

  prds := TproductsDB.Create;
  DataSource := prds.GetProductReviews(ProductID);
	if not Page.IsPostBack then DataBind;
	prds.Free;
end;


end.
